/*
 * TagTreeControl.h
 *
 *  Created on: 23.10.2009
 *      Author: stefan.detter
 */

#ifndef TAGTREECONTROL_H_
#define TAGTREECONTROL_H_

#include <QObject>
#include <TreeView.h>
#include <QPushButton>
#include <QLabel>
#include <QPoint>

#include <def.h>

class TagTreeModel;
class TagTreeProxy;
class TagTreeDelegate;
class TagTreeContextMenu;

class TreeItem;
class RootItem;
class ReaderEntry;
class Application;
class Reader;

class TagTreeControl : public QObject
{
    Q_OBJECT
public:
    TagTreeControl(Application* application, TreeView* treeView, QPushButton* clearButton, QPushButton* backButton,
		   QLabel* selectedReaderLabel, QLabel* selectedReaderPixmapLabel, QWidget* window, QObject* parent = 0);
    virtual ~TagTreeControl();

    TreeItem* selectedItem();
    RootItem* rootItem();

public slots:
    void restoreReaderSelection();
    void itemSetRoot ( const TreeItem* t );
    void removeOfflineReader();

signals:
    void appendGlobalJob(JobType type, const QList<QVariant>& params);

    void itemClicked ( const TreeItem* t );

    void addReaderDialogRequested();

    void readerSelected( Reader* r );
    void readerUnselected( );

private:
    Application* 		m_application;

    TreeView*			m_treeView;
	QPushButton* 		m_clearButton;
	QPushButton* 		m_backButton;
    QLabel* 			m_selectedReaderLabel;
    QLabel*				m_selectedReaderPixmapLabel;

    QWidget*			m_window;

    TagTreeModel* 		m_tagTreeModel;
    TagTreeProxy* 		m_tagTreeProxy;
    TagTreeDelegate* 	m_tagTreeDelegate;
    TagTreeContextMenu* m_tagTreeContextMenu;
};

#endif /* TAGTREECONTROL_H_ */
